# Vespucci 11.1 Highlights

2018-09-16

## Improved preset handling

The internal representation of Presets has been overhauled allowing us to implement some new features without adding to already very byzantine code. The major changes for users are:

* Tri-state checkboxes: this is similar to how JOSM handle checkboxes in the preset display. Preset check fields that can have an explicit "no" or "off" value, start off in an indeterminate state and then can be toggled to on and off. A long press will return the checkbox to the indeterminate state.
* Support for checkgroups. Checkgroups are groups of checkboxes, these can have a label and are handled very similar to multi-select fields, in most cases you will not even see a difference. The change allows a much more compact layout for presets that have many checkboxes, for example the payment methods preset. And caters for a general trend to tagging in such a style.

The default preset has been reworked to work with the new features.

## Taginfo search initiated manually

Version 11.0 introduced "auto-presets". These continue to be available but the online query needs to be explicitly started by tapping a button in the preset search result form. We've found that the performance of the feature varies so much across mobile networks that doing the query automatically was too confusing and annoying.

The corresponding preference to enable/disable the feature has been removed.

## Improved tag copy & paste

Tag copying and pasting has been redone. New functionality includes:

* pasting tags to selected elements in the map view (keyboard short cut __<Ctrl> T__)
* copying of GeoJSON Feature properties to the tag clipboard

## Miscellaneous 

* Keyboard shortcuts in the main screen now work again after they stopped working a while back. 
* Samsung DeX support, Vespucci now reacts to changes in display density and dock insertion/removal.
* Support for free form windows has been improved. 
* Better handling of tile layers which do not match the maximum zoom specified in the configuration.
* Lots of minor improvements.

The full change log is available [here](https://github.com/MarcusWolschon/osmeditor4android/commits/master)

# Upgrading from previous versions

# Known problems

* For known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

